/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityBlockItem;
import dangerzone.items.Items;

public class BlockCherryLeaves
extends Block {
    public BlockCherryLeaves(String n, String txt) {
        super(n, txt);
        this.isSolidForRendering = false;
        this.breaksound = "DangerZone:leavesbreak";
        this.placesound = "DangerZone:leavesplace";
        this.hitsound = "DangerZone:leaves_hit";
        this.isLeaves = true;
        this.randomtick = true;
        this.maxdamage = 5;
        this.burntime = 15;
    }

    @Override
    public String getStepSound() {
        int i = DangerZone.rand.nextInt(4);
        if (i == 0) {
            return "DangerZone:leaves1";
        }
        if (i == 1) {
            return "DangerZone:leaves2";
        }
        if (i == 2) {
            return "DangerZone:leaves3";
        }
        return "DangerZone:leaves4";
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        EntityBlockItem e;
        if (w.getblock(d, x, y - 1, z) == 0 && w.rand.nextInt(30) == 0) {
            Utils.spawnParticlesFromServer(w, "DangerZone:ParticleLeaves", 1, d, x, (double)y - (double)0.1f, z, this.blockID);
        }
        int i = -2;
        while (i <= 2) {
            int j = -2;
            while (j <= 0) {
                int k = -2;
                while (k <= 2) {
                    int t = Math.abs(i) + Math.abs(j) + Math.abs(k);
                    if (t <= 3 && Blocks.canLeavesGrow(w.getblock(d, x + i, y + j, z + k))) {
                        EntityBlockItem e2;
                        if (w.rand.nextInt(450) == 0 && w.getblock(d, x, y - 1, z) == 0 && (e2 = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y - 0.5, (double)z + 0.5)) != null) {
                            e2.fill(Items.cherries, 1);
                            w.spawnEntityInWorld(e2);
                        }
                        return;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        w.setblock(d, x, y, z, 0);
        if (w.getblock(d, x, y - 1, z) == 0) {
            Utils.spawnParticlesFromServer(w, "DangerZone:ParticleLeaves", 5, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.blockID);
        }
        if (w.rand.nextInt(500) == 1 && (e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) != null) {
            e.fill(this, 1);
            w.spawnEntityInWorld(e);
        }
    }

    @Override
    public void onBlockBroken(Player p, int dimension, int x, int y, int z, int s) {
        super.onBlockBroken(p, dimension, x, y, z, s);
        if (p == null) {
            return;
        }
        if (DangerZone.rand.nextInt(10) != 1) {
            return;
        }
        EntityBlockItem e = (EntityBlockItem)p.world.createEntityByName(DangerZone.blockitemname, dimension, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        if (e != null) {
            e.fill(Blocks.sapling_cherry.blockID, 0, 1);
            p.world.spawnEntityInWorld(e);
        }
        if ((e = (EntityBlockItem)p.world.createEntityByName(DangerZone.blockitemname, dimension, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) != null) {
            e.fill(0, Items.cherries.itemID, 1);
            p.world.spawnEntityInWorld(e);
        }
    }
}

